# Portions Copyright 1994-2001 The MathWorks, Inc.
#
# File    : Vehicle_Plant.mk (for Release 2007b and later)
#
# Abstract:
#       Real-Time Workshop template makefile for building a real-time
#       version of a Simulink model to run on National Instruments
#       RT Series hardware. This template makefile uses generated C code
#       and supports the Microsoft Visual C/C++ compiler.
#
#       Note that this template is automatically customized by the Real-Time
#       Workshop build procedure to create "<model>.mk"
#
#       The following defines can be used to modify the behavior of the
#       build:
#
#    	  OPT_OPTS       - Optimization option. Default is -O2. To enable
#    			   debugging specify as OPT_OPTS=-Zd.
#    	  OPTS           - User specific options.
#    	  USER_SRCS      - Additional user source code files, such as files needed by
#    			   S-functions. For example:
#                          USER_SRCS = "c:\projects\MyCode.c".
#    	  USER_INCLUDES  - Additional include paths, such as:
#                          USER_INCLUDES = "-Isomepath"
#                          or
#                          USER_INCLUDES = "-Isomepath -Ianotherpath"
#
#       This template makefile is designed to be used with a system target
#       file that contains 'rtwgensettings.BuildDirSuffix' see grt.tlc


#------------------------ Macros read by make_rtw -----------------------------
#
# The following macros are read by the Real-Time Workshop build procedure:
#
#  MAKECMD         - This is the command used to invoke the make utility
#  HOST            - What platform this template makefile is targeted for 
#                    (i.e. PC or UNIX)
#  BUILD           - Invoke make from the Real-Time Workshop build procedure 
#                    (yes/no)?
#  SYS_TARGET_FILE - Name of system target file.

#
# 	Adapted from grt_vc.tmf
#

USER_INCLUDES = 
USER_SRCS = 

MAKECMD         = nmake
HOST            = PC
BUILD           = yes
SYS_TARGET_FILE = nidll.tlc
BUILD_SUCCESS	= *** Created
CPU             = i386

MODEL           = Vehicle_Plant
MODULES         = Vehicle_Plant_data.c drive_Vehicle_Plant_1.c rtGetInf.c rtGetNaN.c rt_logging.c rt_look.c rt_look2d_normal.c rt_matrx.c rt_nonfinite.c 
MAKEFILE        = Vehicle_Plant.mk
MATLAB_ROOT     = C:\MATLAB\R2009a
ALT_MATLAB_ROOT = C:\MATLAB\R2009a
MATLAB_BIN      = C:\MATLAB\R2009a\bin
ALT_MATLAB_BIN  = C:\MATLAB\R2009a\bin
S_FUNCTIONS     = 
S_FUNCTIONS_LIB = 
SOLVER          = ode4.c
NUMST           = 2
TID01EQ         = 1
NCSTATES        = 12
BUILDARGS       =  GENERATE_REPORT=0
MULTITASKING    = 0
VISUAL_VER		= 8.0
EXT_MODE        = 0
MATLAB_VERSION	= R2009a
STR_MATLAB_VERSION = "$(MATLAB_VERSION)"
NODEBUG         = 1
SIT_VERSION		= 2009
SIT_LIB_DIR     = $(SIT_ROOT)\$(SIT_VERSION)\ModelInterface\tmw\lib\VC$(VISUAL_VER)\$(MATLAB_VERSION)

MODELREFS            = 
SHARED_SRC           = 
SHARED_SRC_DIR       = 
SHARED_BIN_DIR       = 
SHARED_LIB           = 

#--------------------------- Model and reference models -----------------------
MODELLIB                  = Vehicle_Plantlib.lib
MODELREF_LINK_LIBS        = 
MODELREF_INC_PATH         = 
RELATIVE_PATH_TO_ANCHOR   = ..
# ..\..\..\..\..\..\.. or .. or even . if you want it
MODELREF_TARGET_TYPE      = NONE

!if ($(STR_MATLAB_VERSION) != "14.0") && ("$(MATLAB_ROOT)" != "$(ALT_MATLAB_ROOT)")
MATLAB_ROOT = $(ALT_MATLAB_ROOT)
!endif
!if ($(STR_MATLAB_VERSION) != "14.0") && ("$(MATLAB_BIN)" != "$(ALT_MATLAB_BIN)")
MATLAB_BIN = $(ALT_MATLAB_BIN)
!endif

#--------------------------- Tool Specifications ------------------------------
!include $(MATLAB_ROOT)\rtw\c\tools\vctools.mak

PERL = $(MATLAB_ROOT)\sys\perl\win32\bin\perl
#------------------------------ Include/Lib Path ------------------------------

MATLAB_INCLUDES =                    $(MATLAB_ROOT)\simulink\include
MATLAB_INCLUDES = $(MATLAB_INCLUDES);$(MATLAB_ROOT)\extern\include
MATLAB_INCLUDES = $(MATLAB_INCLUDES);$(MATLAB_ROOT)\rtw\c\src
MATLAB_INCLUDES = $(MATLAB_INCLUDES);$(MATLAB_ROOT)\rtw\c\src\ext_mode\common
# Additional file include paths


MATLAB_INCLUDES = $(MATLAB_INCLUDES);C:\DOCUME~1\herniter\MYDOCU~1\Website\ROSE_C~1\MBSD2\SPRING~2\MATLAB~1\LEA524~1\VEHICL~1\Vehicle_Plant_nidll_rtw
MATLAB_INCLUDES = $(MATLAB_INCLUDES);C:\DOCUME~1\herniter\MYDOCU~1\Website\ROSE_C~1\MBSD2\SPRING~2\MATLAB~1\LEA524~1\VEHICL~1
MATLAB_INCLUDES = $(MATLAB_INCLUDES);$(MATLAB_ROOT)\toolbox\physmod\drive\c

INCLUDE = .;$(RELATIVE_PATH_TO_ANCHOR);$(MATLAB_INCLUDES);$(INCLUDE);$(MODELREF_INC_PATH);$(SIT_ROOT)\$(SIT_VERSION)\ModelInterface\

!if "$(SHARED_SRC_DIR)" != ""
INCLUDE = $(INCLUDE);$(SHARED_SRC_DIR)
!endif

RTM_CC_OPTS = -DUSE_RTMODEL
LOG_SRC=
NIDLL_SRC=nidll_main.c

#----------------- Compiler and Linker Options --------------------------------


# Optimization Options
#   Set  OPT_OPTS=-Zd  for debugging
OPT_OPTS = $(DEFAULT_OPT_OPTS)

# General User Options

CRTLIBS = msvcrt.lib

USE_REBUILT_RTW_LIB_FILES = 1

# Other User Options
CC_OPTS = $(OPT_OPTS) $(OPTS) $(RTM_CC_OPTS)

!if "$(MODELREF_TARGET_TYPE)" == "NONE"
CC_OPTS = $(CC_OPTS) -DNI_ROOTMODEL_$(MODEL)
!endif

CPP_REQ_DEFINES = -DMODEL=$(MODEL) -DRT -DNUMST=$(NUMST) \
		  -DTID01EQ=$(TID01EQ) -DNCSTATES=$(NCSTATES) \
		  -DMT=$(MULTITASKING) -DHAVESTDIO -DNATIONAL_INSTRUMENTS_SIT \
		  -D_CRT_SECURE_NO_DEPRECATE

CFLAGS = $(CC_OPTS) $(CPP_REQ_DEFINES) $(USER_INCLUDES) \
	 $(cflags)

CPPFLAGS = $(CPP_OPTS) $(CC_OPTS) $(CPP_REQ_DEFINES) $(USER_INCLUDES) \
	 $(cflags) /GX

LDFLAGS  = $(ldebug) $(dlllflags) 

!if "$(VISUAL_VER)" == "7.1" || "$(VISUAL_VER)" == "6.0"
CFLAGS = $(CFLAGS) $(cvarsdll)
CPPFLAGS = $(CPPFLAGS) $(cvarsdll)
LDFLAGS = $(LDFLAGS) $(CRTLIBS) $(conlibsdll)
!else
CFLAGS = $(CFLAGS) /MT
CPPFLAGS = $(CPPFLAGS) /MT
LDFLAGS = $(LDFLAGS) /NODEFAULTLIB:MSVCRT LIBCMT.LIB $(conlibsdll)
!endif

# libcp.lib is the single-threaded, static lib version of the C++ standard lib
# /GX enables exception handling (needed to use C++ standard lib)

#----------------------------- Source Files -----------------------------------

#DLL
!if "$(MODELREF_TARGET_TYPE)" == "NONE"
PRODUCT   = $(MODEL).dll

REQ_SRCS  = $(MODEL).c $(MODULES) $(NIDLL_SRC) rt_sim.c \
	    $(SOLVER) $(LOG_SRC) $(MODEL).rc

#Model Reference Target
!else
PRODUCT   = $(MODELLIB)
REQ_SRCS  = $(MODULES)
!endif

SRCS = $(REQ_SRCS) $(USER_SRCS) $(S_FUNCTIONS)
OBJS_CPP_UPPER = $(SRCS:.CPP=.obj)
OBJS_CPP_LOWER = $(OBJS_CPP_UPPER:.cpp=.obj)
OBJS_C_UPPER = $(OBJS_CPP_LOWER:.C=.obj)
OBJS_C_LOWER = $(OBJS_C_UPPER:.c=.obj)
OBJS = $(OBJS_C_LOWER:.rc=.res)
SHARED_OBJS = $(SHARED_SRC:.c=.obj)

# ------------------------- Additional Libraries ------------------------------

LIBS =

!if $(USE_REBUILT_RTW_LIB_FILES) == 0
LIBS = $(LIBS) $(MATLAB_ROOT)\toolbox\physmod\drive\lib\win32\drive_vc.lib
!else
LIBS = $(LIBS) $(SIT_LIB_DIR)\drive_sit.lib
!endif 

LIBS = $(LIBS)

CMD_FILE = $(MODEL).lnk
GEN_LNK_SCRIPT = $(MATLAB_ROOT)\rtw\c\tools\mkvc_lnk.pl


#--------------------------------- Rules --------------------------------------

!if "$(MODELREF_TARGET_TYPE)" == "NONE"
#--- Stand-alone model ---
$(PRODUCT) : set_environment_variables create_nidll_code create_lib_dir $(OBJS) $(SHARED_LIB) $(LIBS) $(MODELREF_LINK_LIBS)
	@echo ### Linking ...
	$(PERL) $(GEN_LNK_SCRIPT) $(CMD_FILE) $(OBJS) $(MODELREF_LINK_LIBS)
	$(LD) $(LDFLAGS) $(LIBS) $(SHARED_LIB) $(S_FUNCTIONS_LIB) $(MAT_LIBS) @$(CMD_FILE) /dll -out:$@
	@del $(CMD_FILE)
	@echo $(BUILD_SUCCESS) DLL %cd%\$@
!else
#--- Model reference RTW Target ---
$(PRODUCT) : set_environment_variables create_lib_dir $(OBJS) $(LIBS)
	@echo ### Linking ...
	$(PERL) $(GEN_LNK_SCRIPT) $(CMD_FILE) $(OBJS)
	$(LD) -lib /OUT:$(MODELLIB) @$(CMD_FILE) $(S_FUNCTIONS_LIB)
	@del $(CMD_FILE)
	@echo $(BUILD_SUCCESS) static library $(MODELLIB)
!endif

# Copy files.
create_nidll_code :
	@copy $(SIT_ROOT)\$(SIT_VERSION)\ModelInterface\tmw\$(NIDLL_SRC) .\$(NIDLL_SRC)
	@copy $(SIT_ROOT)\$(SIT_VERSION)\ModelInterface\tmw\model_info.h .

# Create the lib folder if it does not exist.
create_lib_dir :
	@IF NOT EXIST $(SIT_LIB_DIR) (echo mkdir $(SIT_LIB_DIR) )
	@IF NOT EXIST $(SIT_LIB_DIR) (mkdir $(SIT_LIB_DIR) )

{$(MATLAB_ROOT)\rtw\c\src}.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<

# Additional sources

{$(MATLAB_ROOT)\rtw\c\src}.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<

{$(MATLAB_ROOT)\toolbox\physmod\drive\c}.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<



{$(MATLAB_ROOT)\rtw\c\src}.cpp.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $<

{$(MATLAB_ROOT)\toolbox\physmod\drive\c}.cpp.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $<




{$(MATLAB_ROOT)\rtw\c\src}.c{$(SIT_LIB_DIR)}.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $< /Fo$@

{$(MATLAB_ROOT)\toolbox\physmod\drive\c}.c{$(SIT_LIB_DIR)}.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $< /Fo$@



{$(MATLAB_ROOT)\rtw\c\src}.cpp{$(SIT_LIB_DIR)}.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $< /Fo$@

{$(MATLAB_ROOT)\toolbox\physmod\drive\c}.cpp{$(SIT_LIB_DIR)}.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $< /Fo$@



# Look in simulink/src helper files

{$(MATLAB_ROOT)\simulink\src}.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<

{$(MATLAB_ROOT)\simulink\src}.cpp.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $<

# Put these rule last, otherwise nmake will check toolboxes first

{$(RELATIVE_PATH_TO_ANCHOR)}.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<

{$(RELATIVE_PATH_TO_ANCHOR)}.cpp.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $<

.cpp.obj :
	@echo ### Compiling $<
	$(CC) $(CPPFLAGS) $<

$(MODEL).obj :
	@echo ### Compiling the source $(MODEL)
	$(CC) $(CFLAGS) -DRVE $(MODEL).c

.c.obj :
	@echo ### Compiling $<
	$(CC) $(CFLAGS) $<
	
.rc.res : 
	@echo ### Compiling $<
	$(RC) $<

!if "$(SHARED_LIB)" != ""
$(SHARED_LIB) : $(SHARED_SRC)
	@echo ### Creating $@
	@$(CC) $(CFLAGS) -Fo$(SHARED_BIN_DIR)\ $?
	@$(LIBCMD) /nologo /out:$@ $(SHARED_OBJS)
	@echo ### $@ Created
!endif

set_environment_variables:
	@set INCLUDE=$(INCLUDE)
	@set LIB=$(LIB)

# Libraries:




MODULES_drive = \
	drive_00086bb8.obj \
	drive_04d32aaa.obj \
	drive_06b3d5f7.obj \
	drive_09b42609.obj \
	drive_14095aa5.obj \
	drive_18bf41e1.obj \
	drive_24b97a0b.obj \
	drive_29d1a934.obj \
	drive_2eb0d43f.obj \
	drive_2f69c792.obj \
	drive_37da8b0a.obj \
	drive_3b6b9e79.obj \
	drive_3c08372a.obj \
	drive_3dd9ff85.obj \
	drive_3fb90b16.obj \
	drive_410ec910.obj \
	drive_42bd2888.obj \
	drive_4fde9639.obj \
	drive_51d0b022.obj \
	drive_53b24b68.obj \
	drive_53bff7a9.obj \
	drive_5769dfdf.obj \
	drive_5a0ddde3.obj \
	drive_5f018d7d.obj \
	drive_6dd6508c.obj \
	drive_7803c6e3.obj \
	drive_7bb44eb9.obj \
	drive_7d024e26.obj \
	drive_7d06989b.obj \
	drive_7eb1a98c.obj \
	drive_7eb471c2.obj \
	drive_7eb7cd5a.obj \
	drive_81b41582.obj \
	drive_856557c4.obj \
	drive_86ded01b.obj \
	drive_88018182.obj \
	drive_89dbfb38.obj \
	drive_91670bbf.obj \
	drive_93094e83.obj \
	drive_990ee54e.obj \
	drive_9e6825d5.obj \
	drive_9fbfe43c.obj \
	drive_a00782e0.obj \
	drive_a3bcbdd6.obj \
	drive_a5020cf1.obj \
	drive_a9b31829.obj \
	drive_a9b5c855.obj \
	drive_ad6deb4c.obj \
	drive_b6644a7b.obj \
	drive_b961df4c.obj \
	drive_bb0428e4.obj \
	drive_c0b2d23a.obj \
	drive_c6030848.obj \
	drive_c9039e0f.obj \
	drive_cab71e3f.obj \
	drive_cdd6dbbe.obj \
	drive_ce678e38.obj \
	drive_d20c8725.obj \
	drive_e10b9ab1.obj \
	drive_e4061127.obj \
	drive_e7b84bba.obj \
	drive_eadc2f29.obj \
	drive_f268bb40.obj \
	drive_f4da6f90.obj \
	drive_f76fec26.obj \
	drive_f865cda7.obj \
	drive_f9b3d817.obj \


drive.lib : rtw_proj.tmw $(MAKEFILE) $(MODULES_drive)
	@echo ### Creating $@
	$(LIBCMD) /nologo /out:$@ $(MODULES_drive)
	@echo ### Created $@



MODULES_drive_sit = \
	$(SIT_LIB_DIR)\drive_00086bb8.obj \
	$(SIT_LIB_DIR)\drive_04d32aaa.obj \
	$(SIT_LIB_DIR)\drive_06b3d5f7.obj \
	$(SIT_LIB_DIR)\drive_09b42609.obj \
	$(SIT_LIB_DIR)\drive_14095aa5.obj \
	$(SIT_LIB_DIR)\drive_18bf41e1.obj \
	$(SIT_LIB_DIR)\drive_24b97a0b.obj \
	$(SIT_LIB_DIR)\drive_29d1a934.obj \
	$(SIT_LIB_DIR)\drive_2eb0d43f.obj \
	$(SIT_LIB_DIR)\drive_2f69c792.obj \
	$(SIT_LIB_DIR)\drive_37da8b0a.obj \
	$(SIT_LIB_DIR)\drive_3b6b9e79.obj \
	$(SIT_LIB_DIR)\drive_3c08372a.obj \
	$(SIT_LIB_DIR)\drive_3dd9ff85.obj \
	$(SIT_LIB_DIR)\drive_3fb90b16.obj \
	$(SIT_LIB_DIR)\drive_410ec910.obj \
	$(SIT_LIB_DIR)\drive_42bd2888.obj \
	$(SIT_LIB_DIR)\drive_4fde9639.obj \
	$(SIT_LIB_DIR)\drive_51d0b022.obj \
	$(SIT_LIB_DIR)\drive_53b24b68.obj \
	$(SIT_LIB_DIR)\drive_53bff7a9.obj \
	$(SIT_LIB_DIR)\drive_5769dfdf.obj \
	$(SIT_LIB_DIR)\drive_5a0ddde3.obj \
	$(SIT_LIB_DIR)\drive_5f018d7d.obj \
	$(SIT_LIB_DIR)\drive_6dd6508c.obj \
	$(SIT_LIB_DIR)\drive_7803c6e3.obj \
	$(SIT_LIB_DIR)\drive_7bb44eb9.obj \
	$(SIT_LIB_DIR)\drive_7d024e26.obj \
	$(SIT_LIB_DIR)\drive_7d06989b.obj \
	$(SIT_LIB_DIR)\drive_7eb1a98c.obj \
	$(SIT_LIB_DIR)\drive_7eb471c2.obj \
	$(SIT_LIB_DIR)\drive_7eb7cd5a.obj \
	$(SIT_LIB_DIR)\drive_81b41582.obj \
	$(SIT_LIB_DIR)\drive_856557c4.obj \
	$(SIT_LIB_DIR)\drive_86ded01b.obj \
	$(SIT_LIB_DIR)\drive_88018182.obj \
	$(SIT_LIB_DIR)\drive_89dbfb38.obj \
	$(SIT_LIB_DIR)\drive_91670bbf.obj \
	$(SIT_LIB_DIR)\drive_93094e83.obj \
	$(SIT_LIB_DIR)\drive_990ee54e.obj \
	$(SIT_LIB_DIR)\drive_9e6825d5.obj \
	$(SIT_LIB_DIR)\drive_9fbfe43c.obj \
	$(SIT_LIB_DIR)\drive_a00782e0.obj \
	$(SIT_LIB_DIR)\drive_a3bcbdd6.obj \
	$(SIT_LIB_DIR)\drive_a5020cf1.obj \
	$(SIT_LIB_DIR)\drive_a9b31829.obj \
	$(SIT_LIB_DIR)\drive_a9b5c855.obj \
	$(SIT_LIB_DIR)\drive_ad6deb4c.obj \
	$(SIT_LIB_DIR)\drive_b6644a7b.obj \
	$(SIT_LIB_DIR)\drive_b961df4c.obj \
	$(SIT_LIB_DIR)\drive_bb0428e4.obj \
	$(SIT_LIB_DIR)\drive_c0b2d23a.obj \
	$(SIT_LIB_DIR)\drive_c6030848.obj \
	$(SIT_LIB_DIR)\drive_c9039e0f.obj \
	$(SIT_LIB_DIR)\drive_cab71e3f.obj \
	$(SIT_LIB_DIR)\drive_cdd6dbbe.obj \
	$(SIT_LIB_DIR)\drive_ce678e38.obj \
	$(SIT_LIB_DIR)\drive_d20c8725.obj \
	$(SIT_LIB_DIR)\drive_e10b9ab1.obj \
	$(SIT_LIB_DIR)\drive_e4061127.obj \
	$(SIT_LIB_DIR)\drive_e7b84bba.obj \
	$(SIT_LIB_DIR)\drive_eadc2f29.obj \
	$(SIT_LIB_DIR)\drive_f268bb40.obj \
	$(SIT_LIB_DIR)\drive_f4da6f90.obj \
	$(SIT_LIB_DIR)\drive_f76fec26.obj \
	$(SIT_LIB_DIR)\drive_f865cda7.obj \
	$(SIT_LIB_DIR)\drive_f9b3d817.obj \


$(SIT_LIB_DIR)\drive_sit.lib : $(MODULES_drive_sit)
	@echo ### Creating $@
	@IF EXIST $(SIT_LIB_DIR)\drive_sit.txt (del $(SIT_LIB_DIR)\drive_sit.txt)
	@echo $(SIT_LIB_DIR)\drive_00086bb8.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_04d32aaa.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_06b3d5f7.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_09b42609.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_14095aa5.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_18bf41e1.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_24b97a0b.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_29d1a934.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_2eb0d43f.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_2f69c792.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_37da8b0a.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_3b6b9e79.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_3c08372a.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_3dd9ff85.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_3fb90b16.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_410ec910.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_42bd2888.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_4fde9639.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_51d0b022.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_53b24b68.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_53bff7a9.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_5769dfdf.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_5a0ddde3.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_5f018d7d.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_6dd6508c.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7803c6e3.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7bb44eb9.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7d024e26.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7d06989b.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7eb1a98c.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7eb471c2.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_7eb7cd5a.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_81b41582.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_856557c4.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_86ded01b.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_88018182.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_89dbfb38.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_91670bbf.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_93094e83.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_990ee54e.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_9e6825d5.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_9fbfe43c.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_a00782e0.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_a3bcbdd6.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_a5020cf1.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_a9b31829.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_a9b5c855.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_ad6deb4c.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_b6644a7b.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_b961df4c.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_bb0428e4.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_c0b2d23a.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_c6030848.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_c9039e0f.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_cab71e3f.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_cdd6dbbe.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_ce678e38.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_d20c8725.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_e10b9ab1.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_e4061127.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_e7b84bba.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_eadc2f29.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_f268bb40.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_f4da6f90.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_f76fec26.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_f865cda7.obj >> $(SIT_LIB_DIR)\drive_sit.txt
	@echo $(SIT_LIB_DIR)\drive_f9b3d817.obj >> $(SIT_LIB_DIR)\drive_sit.txt

	$(LIBCMD) /nologo /out:$@ @$(SIT_LIB_DIR)\drive_sit.txt
	@echo ### Created $@



#----------------------------- Dependencies -----------------------------------

$(OBJS) : $(MAKEFILE) rtw_proj.tmw
